<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AutentikasiController extends Controller
{
    public function index()
    {
        return view('admin.login');
    }

    public function login(Request $request)
    {
        $request->validate([
            'username' => 'required',
            'password' => 'required',
        ], [
            'username.required' => 'Username wajid diisi!',
            'password.required' => 'Password wajid diisi!',
        ]);

        $dataLogin = [
            'username' => $request->username,
            'password' => $request->password,
        ];

        if (Auth::guard('web')->attempt($dataLogin)) {
            if (Auth::user()->level == 1) {
                return redirect('dashboard');
            } else {
                return redirect('kasir');
            }
        }

        if (Auth::guard('member')->attempt($dataLogin)) {
            // $request->session()->regenerate();
            return redirect('/home');
        }
        session()->flash('msgError', 'Username & Password yang anda masukan salah');
        return redirect('login')->withInput();
    }

    public function logout(Request $request)
    {
        Auth::logout();
        return redirect('login');
    }
}
